local _M = {}

function _M.parse_headers(header)
    local headers = ngx.req.get_headers()
    return headers[header] or 1
end

function _M.get_arg(arg)
    local args = ngx.req.get_uri_args()
    return args[arg] or 1
end

function _M.post_arg(arg)
    local args, err = ngx.req.get_post_args()
    return args[arg] or 1
end

function _M.body_data()
    ngx.req.read_body()
    local data = ngx.req.get_body_data()
    return data
end

return _M
