package main

import (
	"bufio"
	"fmt"
	"log"
	"net/http"
	"os"
	"strings"
	"sync"
	"time"
)

var instance = map[string]int{
	"instance": 0,
}

var state = map[string]*user{}

var mutex = &sync.Mutex{}

type Ammo struct {
	Tag  string
	Mids int
}

type user struct {
	//Mu &sync.Mutex
	UID  string
	Mids []string
	Mark string
	Fid  string
}

type Payload struct {
	Method     string
	URI        string
	Data       string
	Assert     string
	Xrequestid string
}

func makeTimestamp() string {
	return time.Now().Format("15:04:05.000000")
}

func (g *Gun) makeReq(payload *Payload) *http.Request {
	req, _ := http.NewRequest(payload.Method, strings.Join([]string{"http://", g.conf.Target, payload.URI}, ""), strings.NewReader(payload.Data))
	req.Header.Add("Content-Type", "application/x-www-form-urlencoded")
	req.Header.Add("Connection", "close")
	req.Header.Add("X-Real-IP", "213.180.206.57")
	req.Header.Add("X-Request-Id", payload.Xrequestid)
	req.Header.Add("User-Agent", "pandora")
	return req
}

func (g *Gun) genPayload(ammo *Ammo) *Payload {
	payload := Payload{
		Assert:     "\"result\":\"ok\"",
		Xrequestid: makeTimestamp() + "_" + g.user,
	}
	switch ammo.Tag {
	case "mark":
		payload.Method = "POST"
		payload.URI = "/mark"
		payload.Data = "mids=" + g.midCluer(ammo) + "&status=" + state[g.user].Mark + "&uid=" + state[g.user].UID + "&postmaster=no&ora_dsn=mail_dsn&source=node_js&login=" + g.user + "&karma=0&karma_status=0"
		if state[g.user].Mark == "read" {
			state[g.user].Mark = "not_read"
		} else {
			state[g.user].Mark = "read"
		}
	case "complex_move":
		payload.Method = "POST"
		payload.URI = "/complex_move"
		payload.Data = "dest_fid=" + state[g.user].Fid + "&with_sent=0&mids=" + g.midCluer(ammo) + "&login=" + g.user + "&uid=" + state[g.user].UID + "&source=node_js&karma=0&karma_status=0&country=ru&postmaster=no&ip=2a02%3A6b8%3A0%3A107%3A9556%3Ae5fe%3Aa55d%3Af2af"
		if state[g.user].Fid == "1" || state[g.user].Fid == "2" {
			state[g.user].Fid = "7"
		} else {
			state[g.user].Fid = "1"
		}
	case "spam":
		payload.Method = "POST"
		payload.URI = "/spam"
		payload.Data = "mids=" + g.midCluer(ammo) + "&with_sent=0&movefile=2&uid=" + state[g.user].UID + "&postmaster=no&ora_dsn=mail_dsn&source=node_js&login=" + g.user + "&karma=0&karma_status=0&source=node_js"
	case "unspam":
		payload.Method = "POST"
		payload.URI = "/unspam"
		payload.Data = "mids=" + g.midCluer(ammo) + "&with_sent=0&movefile=1&uid=" + state[g.user].UID + "&postmaster=no&ora_dsn=mail_dsn&source=node_js&login=" + g.user + "&karma=0&karma_status=0&source=node_js"
	default:
		fmt.Println("Wrong handler: ", ammo.Tag)
		payload.Method = "GET"
		payload.URI = ""
	}
	return &payload
}

func (g *Gun) midCluer(ammo *Ammo) string {
	var output string
	for i := 0; i < ammo.Mids; i++ {
		if len(output) != 0 {
			output += "%2C"
		}
		output += state[g.user].Mids[i]
	}
	return output
}

func InitialState() {
	var login string
	file, err := os.Open("./output.ssv")
	if err != nil {
		log.Fatal(err)
	}

	defer func() { _ = file.Close() }()

	scanner := bufio.NewScanner(file)
	for scanner.Scan() {
		var splitted = strings.Split(scanner.Text(), ";")
		login = splitted[0]
		state[login] = &user{
			UID:  splitted[1],
			Mids: strings.Split(splitted[3], ","),
			Mark: "read",
			Fid:  "1",
		}
	}
}
