import sys
import random
import json
from random import randint, choice
import argparse

parser = argparse.ArgumentParser()
parser.add_argument("--profile", type=str, help="string with json profile, in handler:weight format", default='{"mark": 1}')
parser.add_argument("--mids", type=int, help="number of mids in one reques", default=1)
args = parser.parse_args()

def weighted_json_choice(choices):
   '''dict where key is choice and value probability'''
   total = sum(choices[choice] for choice in choices)
   r = random.uniform(0, total)
   upto = 0 
   for choice in choices:
      if upto + choices[choice] >= r:
         return choice
      upto += choices[choice]

class Ammo(object):
    def __init__(self):
        self.output = []
        self.out_template = ('{"tag": "%s", "mids": %s}\n')
        self.legal_handlers = [
            "mark",
            "complex_move",
            "spam",
            "unspam"
        ] 

    def make_ammo(self, profile, mids):
        for i in range(4000):
            tag = weighted_json_choice(json.loads(profile))
            if tag in self.legal_handlers:
                self.output.append(self.out_template % (tag, mids))

    def json_output(self):
        with open("ammo.json", "w") as fd:
            for line in self.output:
                fd.write(line)

if __name__ == "__main__":
    ammo = Ammo()
    ammo.make_ammo(args.profile, args.mids)
    ammo.json_output()
