#pragma once

#include <yplatform/ptree.h>
#include <mailbox_oper/module.h>
#include <mailbox_oper/logger.h>
#include <mailbox_oper/mailbox_oper_routines.h>

namespace mbox_oper {

class MailboxOperModuleImpl: public MailboxOperModule {
public:
    void init(const yplatform::ptree& xml) {
        config_.reset(new Configuration(xml));
        LOGDOG_(logger_, notice, log::message="mailbox_oper module initialized");
    }

    void reload(const boost::property_tree::ptree& xml) {
        config_.reset(new Configuration(xml));
        LOGDOG_(logger_, notice, log::message="mailbox_oper module reloaded");
    }

    void start() {
        LOGDOG_(logger_, notice, log::message="mailbox_oper module started");
    }

    void stop() {
        LOGDOG_(logger_, notice, log::message="mailbox_oper module stopped");
    }

    void fini() {
        LOGDOG_(logger_, notice, log::message="mailbox_oper module finished");
    }

    MailboxOper api(MailboxOperParams& params, ContextPtr context, YieldCtx yield) const override {
        return getMailboxOper(config_, params, context, yield);
    }

    ConfigurationPtr config() const override {
        return config_;
    }
private:
    ConfigurationPtr config_;
    Logger logger_ = getLogger();
};

} // namespace
