#pragma once

#include <boost/property_tree/ptree.hpp>
#include <user_journal/service.h>
#include <macs/tabs_map.h>

#include <macs_pg/macs_pg.h>
#include <ymod_httpclient/request.h>
#include <mail/ymod_maildb/include/module.h>
#include <mail/http_getter/client/include/module.h>

namespace mbox_oper {


YREFLECTION_DEFINE_ENUM_INLINE(UserInfoStrategy,
    paramsOnly,
    paramsThenBlackbox,
    blackboxThenParams,
    blackboxOnly
);

class Configuration {
public:
    Configuration(const boost::property_tree::ptree& tree);

    http_getter::TypedEndpoint blackboxEndpoint;
    http_getter::TypedModulePtr httpGetter;

    user_journal::ServicePtr journalService() const;

    ymod_maildb::ModulePtr maildb;

    macs::pg::logging::v2::LogPtr pgLog;
    macs::deprecated::TabsMap tabsMap;
    UserInfoStrategy userInfoStrategy;
};

using ConfigurationPtr = boost::shared_ptr<Configuration>;

} // namespace

