#ifndef MBOX_OPER_GET_USER_JOURNAL_H
#define MBOX_OPER_GET_USER_JOURNAL_H

#include <user_journal/service.h>
#include <mailbox_oper/params.h>

namespace mbox_oper {

inline user_journal::Journal getJournal(const MailboxOperParams& params, const std::string& module,
        user_journal::ServicePtr service) {
    using namespace user_journal::parameters;
    return service->createJournal(params.uid,
            id::ip(params.remoteIp),
            id::module(module),
            id::testBuckets(params.testBuckets),
            id::enabledTestBuckets(params.enabledTestBuckets),
            id::sessionInfo(params.sessionInfo),
            id::yandexuidCookie(params.yandexUidCookie),
            id::iCookie(params.iCookie),
            id::clientType(params.clientType),
            id::clientVersion(params.clientVersion),
            id::userAgent(params.userAgent),
            id::connectionId(params.connectionId),
            id::requestId(params.requestId));
}

} // namespace

#endif // MBOX_OPER_GET_USER_JOURNAL_H
