#pragma once

#include <map>

namespace mbox_oper {

template<class Items, class Key>
auto groupBy(const Items& items, Key key) {
    std::map<decltype(key(typename Items::value_type())), Items> ret;

    for (const auto& element: items) {
        const auto k = key(element);
        if (ret.find(k) == ret.end()) {
            ret[k] = Items(1, element);
        } else {
            ret[k].push_back(element);
        }
    }

    return ret;
}

}
