#pragma once

#include <yplatform/log.h>
#include <logdog/logger.h>
#include <logdog/format/tskv.h>
#include <logdog/backend/yplatform_log.h>
#include <mail/mops/include/common/logdog.h>
#include <mailbox_oper/params.h>
#include <mailbox_oper/context.h>

namespace mbox_oper {
namespace log {

using namespace ::mops::logdog;

LOGDOG_DEFINE_ATTRIBUTE(mbox_oper::ResolveOptions, resolve_options)
LOGDOG_DEFINE_ATTRIBUTE(std::string, exclude_status)

LOGDOG_DEFINE_ATTRIBUTE(mbox_oper::Mids, mids)
LOGDOG_DEFINE_ATTRIBUTE(mbox_oper::Tids, tids)
LOGDOG_DEFINE_ATTRIBUTE(mbox_oper::Fid, fid)
LOGDOG_DEFINE_ATTRIBUTE(std::string, tab)
LOGDOG_DEFINE_ATTRIBUTE(mbox_oper::Lid, lid)

constexpr static auto formatter = ::logdog::tskv::make_formatter(BOOST_HANA_STRING("mail-mops-tskv-log"));

} // namespace log

inline auto getLogger() {
    auto logger = std::make_shared<yplatform::log::source>(YGLOBAL_LOG_SERVICE, "mops");
    return ::logdog::make_log(log::formatter, std::move(logger));
}

using Logger = decltype(getLogger());

inline auto getContextLogger(ContextPtr ctx) {
    return log::makeContextLogger(getLogger(), std::move(ctx));
}

using ContextLogger = decltype(getContextLogger(nullptr));

} // namespace mbox_oper

namespace logdog::tskv {

template <>
struct to_tskv_impl<mbox_oper::ResolveOptions> {
    template<typename Out>
    static void apply(Out& out, const char* key, const mbox_oper::ResolveOptions& v) {
        std::string name = key;

        std::vector<std::string> skipFoldersNames;
        skipFoldersNames.reserve(v.skipFolders().size());
        boost::transform(v.skipFolders(), std::back_inserter(skipFoldersNames),
                         [](const auto& symbol) { return symbol.title(); });

        out << ytskv::attr(name + ".skip_folders", "[" + boost::join(skipFoldersNames, ",") + "]")
            << ytskv::attr(name + ".exclude_status", mbox_oper::statusToString(v.excludeStatus()))
            << ytskv::attr(name + ".cascade.enable", v.cascadeOptions().enable())
            << ytskv::attr(name + ".cascade.exclude_filters_count", v.cascadeOptions().excludeFilters().size())
            << ytskv::attr(name + ".sync_by_hdr_message_id", v.syncByHdrMessageId());
    }
};

}
