#pragma once

#include <mailbox_oper/params.h>
#include <mailbox_oper/context.h>
#include <mailbox_oper/logger.h>
#include <macs_pg/service/service.h>

namespace mbox_oper {

using Envelopes = std::vector<macs::Envelope>;
using OptEnvelope = boost::optional<macs::Envelope>;

class MailboxMeta {
public:
    virtual ~MailboxMeta() = default;
    virtual Mids getMids(const Mids& mids, YieldCtx yieldCtx, const OptStatus& excludeStatus = OptStatus()) const = 0;
    virtual Mids getMids(const Tids& tids, const ResolveOptions& options, YieldCtx yieldCtx) const = 0;
    virtual Mids getMids(const Mids& mids, const Tids& tids, const ResolveOptions& options, YieldCtx yieldCtx) const = 0;
    virtual Mids getMids(const Fid& fid, const FidFilter& filter, YieldCtx yieldCtx,
                         const OptStatus& excludeStatus = OptStatus()) const = 0;
    virtual Mids getMids(const Fid& fid, const FidFilter& filter, const std::optional<Mid>& fromMid, std::size_t limit,
                         YieldCtx yieldCtx, const OptStatus& excludeStatus = OptStatus()) const = 0;
    virtual Mids getMids(const Lid& lid, YieldCtx yieldCtx) const = 0;
    virtual Mids getMids(const macs::Tab::Type& tab, YieldCtx yieldCtx,
                         const OptStatus& excludeStatus = OptStatus()) const = 0;
    virtual Mids getMidsInFolderCascade(const Fid& fid, const ExcludeFilters& excludeFilters, YieldCtx yieldCtx) const = 0;
    virtual Mids getMidsByTidAndWithSameHeaders(const Tid& tid, YieldCtx yieldCtx) const = 0;
    virtual Mids getMids(const macs::HdrDateAndMessageIdVec& hdrPairs, YieldCtx yieldCtx) const = 0;

    virtual size_t getMidsCount(const Fid& fid, const OptStatus& excludeStatus, YieldCtx yieldCtx) const = 0;
    virtual size_t getMidsCount(const Lid& lid, YieldCtx yieldCtx) const = 0;
    virtual size_t getMidsCount(const macs::Tab::Type& tab, const OptStatus& excludeStatus, YieldCtx yieldCtx) const = 0;
    virtual size_t getMessageCountInThreads(const Tids& tids, YieldCtx yieldCtx) const = 0;
    virtual size_t getMidsCountCascade(const Fid& fid, const ExcludeFilters& excludeFilters, YieldCtx yieldCtx) const = 0;

    virtual Fid getFid(const macs::Folder::Symbol& symbol, YieldCtx yieldCtx) const = 0;
    virtual macs::Label getLabel(const macs::Label::Symbol& symbol, YieldCtx yieldCtx) const = 0;

    virtual OptEnvelope getEnvelope(const Mid& mid, YieldCtx yieldCtx) const = 0;

    virtual macs::LabelSet getLabelSet(YieldCtx yieldCtx) const = 0;

    virtual macs::settings::ParametersPtr getParameters(std::vector<std::string> names, YieldCtx yieldCtx) const = 0;
};

class MailboxMetaImpl : public MailboxMeta {
public:
    MailboxMetaImpl(macs::ServicePtr metadata, ContextPtr context);

    Mids getMids(const Mids& mids, YieldCtx yieldCtx, const OptStatus& excludeStatus = OptStatus()) const override;
    Mids getMids(const Tids& tids, const ResolveOptions& options, YieldCtx yieldCtx) const override;
    Mids getMids(const Mids& mids, const Tids& tids, const ResolveOptions& options, YieldCtx yieldCtx) const override;
    Mids getMids(const Fid& fid, const FidFilter& filter, YieldCtx yieldCtx,
                 const OptStatus& excludeStatus = OptStatus()) const override;
    Mids getMids(const Fid& fid, const FidFilter& filter, const std::optional<Mid>& fromMid, std::size_t limit,
                 YieldCtx yieldCtx, const OptStatus& excludeStatus = OptStatus()) const override;
    Mids getMids(const Lid& lid, YieldCtx yieldCtx) const override;
    Mids getMids(const macs::Tab::Type& tab, YieldCtx yieldCtx,
                 const OptStatus& excludeStatus = OptStatus()) const override;
    Mids getMidsInFolderCascade(const Fid& fid, const ExcludeFilters& excludeFilters, YieldCtx yieldCtx) const override;
    Mids getMidsByTidAndWithSameHeaders(const Tid& tid, YieldCtx yieldCtx) const override;
    Mids getMids(const macs::HdrDateAndMessageIdVec& hdrPairs, YieldCtx yieldCtx) const override;

    size_t getMidsCount(const Fid& fid, const OptStatus& excludeStatus, YieldCtx yieldCtx) const override;
    size_t getMidsCount(const Lid& lid, YieldCtx yieldCtx) const override;
    size_t getMidsCount(const macs::Tab::Type& tab, const OptStatus& excludeStatus, YieldCtx yieldCtx) const override;
    size_t getMessageCountInThreads(const Tids& tids, YieldCtx yieldCtx) const override;
    size_t getMidsCountCascade(const Fid& fid, const ExcludeFilters& excludeFilters, YieldCtx yieldCtx) const override;

    Fid getFid(const macs::Folder::Symbol& symbol, YieldCtx yieldCtx) const override;
    macs::Label getLabel(const macs::Label::Symbol& symbol, YieldCtx yieldCtx) const override;

    OptEnvelope getEnvelope(const Mid& mid, YieldCtx yieldCtx) const override;

    macs::LabelSet getLabelSet(YieldCtx yieldCtx) const override;

    Mids selectMids(macs::ThreadMailboxItems items, const SkipFolders& skipFolders, YieldCtx yieldCtx) const;

    std::vector<macs::Folder> selectFoldersCascade(const Fid& rootFid, const ExcludeFilters& excludeFilters, YieldCtx yieldCtx) const;

    Mids resolveMids(const Mids& mids, const Tids& tids, const ResolveOptions& options, YieldCtx yieldCtx) const;

    macs::settings::ParametersPtr getParameters(std::vector<std::string> names, YieldCtx yieldCtx) const override;

    macs::ServicePtr metadata;
    ContextLogger logger;
    ContextPtr context;
};

} // namespace mbox_oper
