#pragma once

#include <mailbox_oper/params.h>

namespace mbox_oper {

template <typename Params>
struct Operation {
    static_assert(std::is_base_of<BaseParams, Params>::value,
                  "Invalid operation parameters type");
    Mids mids;
    Params params;
};

using MarkOperation = Operation<MarkParams>;
using PurgeOperation = Operation<PurgeParams>;
using SpamOperation = Operation<SpamParams>;
using UnspamOperation = Operation<UnspamParams>;
using MoveOperation = Operation<MoveParams>;
using ComplexMoveOperation = Operation<ComplexMoveParams>;
using TrashOperation = Operation<TrashParams>;
using RemoveOperation = Operation<RemoveParams>;
using LabelOperation = Operation<LabelParams>;
using UnlabelOperation = Operation<UnlabelParams>;
using DeleteLabelOperation = Operation<DeleteLabelParams>;
using DeleteFolderOperation = Operation<DeleteFolderParams>;

}
