#pragma once

#include <yamail/data/reflection/reflection.h>
#include <mailbox_oper/params.h>

YREFLECTION_ADAPT_ADT(mbox_oper::MidsSourceData::Days,
    (days, int, int, obj.count(), (obj = mbox_oper::MidsSourceData::Days(val)))
)

YREFLECTION_ADAPT_ADT(mbox_oper::Fid,
    (value, std::string, std::string, obj, (obj = mbox_oper::Fid(val)))
)

YREFLECTION_ADAPT_ADT(mbox_oper::Lid,
    (value, std::string, std::string, obj, (obj = mbox_oper::Lid(val)))
)

YREFLECTION_ADAPT_ADT(mbox_oper::MidsSourceData,
    YREFLECTION_MEMBER(mbox_oper::Mids, mids)
    YREFLECTION_MEMBER(mbox_oper::Tids, tids)
    YREFLECTION_MEMBER(std::string, fid)
    YREFLECTION_MEMBER(std::string, lid)
    YREFLECTION_MEMBER(mbox_oper::MidsSourceData::Days, age)
    YREFLECTION_MEMBER(std::string, subject)
    YREFLECTION_MEMBER(std::string, from)
    YREFLECTION_MEMBER(std::string, tabName)
    YREFLECTION_MEMBER(std::string, fromMid)
    YREFLECTION_MEMBER(std::string, limit)
)

YREFLECTION_ADAPT_ADT(mbox_oper::MailboxOperParams,
    YREFLECTION_MEMBER(std::string, uid)
    YREFLECTION_MEMBER(std::string, login)
    YREFLECTION_MEMBER(std::string, karma)
    YREFLECTION_MEMBER(std::string, karmaStatus)
    YREFLECTION_MEMBER(std::string, remoteIp)
    YREFLECTION_MEMBER(std::string, userAgent)
    YREFLECTION_MEMBER(std::string, sessionInfo)
    YREFLECTION_MEMBER(std::string, yandexUidCookie)
    YREFLECTION_MEMBER(std::string, iCookie)
    YREFLECTION_MEMBER(std::string, source)
    YREFLECTION_MEMBER(std::string, clientType)
    YREFLECTION_MEMBER(std::string, clientVersion)
    YREFLECTION_MEMBER(std::string, connectionId)
    YREFLECTION_MEMBER(std::string, requestId)
    YREFLECTION_MEMBER(std::string, testBuckets)
    YREFLECTION_MEMBER(std::string, enabledTestBuckets)
)

YREFLECTION_ADAPT_ADT(mbox_oper::SpamParams,
    YREFLECTION_MEMBER(bool, shouldMove_)
    YREFLECTION_MEMBER(mbox_oper::OptBool, withSent_)
)

YREFLECTION_ADAPT_ADT(mbox_oper::UnspamParams,
    YREFLECTION_MEMBER(mbox_oper::Fid, destFid_)
    YREFLECTION_MEMBER(bool, shouldMove_)
    YREFLECTION_MEMBER(mbox_oper::OptString, destTab_)
)

YREFLECTION_ADAPT_ADT(mbox_oper::PurgeParams,
)

YREFLECTION_ADAPT_ADT(mbox_oper::RemoveParams,
    YREFLECTION_MEMBER(bool, trashOnly_)
    YREFLECTION_MEMBER(mbox_oper::OptBool, withSent_)
    YREFLECTION_MEMBER(mbox_oper::OptFid, fid_)
)

YREFLECTION_ADAPT_ADT(mbox_oper::TrashParams,
)

YREFLECTION_ADAPT_ADT(mbox_oper::MoveParams,
    YREFLECTION_MEMBER(mbox_oper::Fid, destFid_)
    YREFLECTION_MEMBER(mbox_oper::OptString, destTab_)
)

YREFLECTION_ADAPT_ADT(mbox_oper::ComplexMoveParams,
    YREFLECTION_MEMBER(mbox_oper::Fid, destFid_)
    YREFLECTION_MEMBER(mbox_oper::OptBool, withSent_)
    YREFLECTION_MEMBER(mbox_oper::OptString, destTab_)
)

YREFLECTION_ADAPT_ADT(mbox_oper::MarkParams,
    YREFLECTION_ENUM_MEMBER(macs::Envelope::Status, status_)
)

YREFLECTION_ADAPT_ADT(mbox_oper::LabelParams,
    YREFLECTION_MEMBER(mbox_oper::Lids, lids_)
)

YREFLECTION_ADAPT_ADT(mbox_oper::UnlabelParams,
    YREFLECTION_MEMBER(mbox_oper::Lids, lids_)
)

YREFLECTION_ADAPT_ADT(mbox_oper::DeleteLabelParams,
    YREFLECTION_MEMBER(mbox_oper::Lid, lid_)
)

YREFLECTION_ADAPT_ADT(mbox_oper::DeleteFolderParams,
    YREFLECTION_MEMBER(mbox_oper::Fid, fid_)
)
