#pragma once

#include <boost/asio/spawn.hpp>
#include <io_result/io_result.h>

namespace mbox_oper {

using io_result::make_yield_context;

using YieldCtx = boost::asio::yield_context;

template <typename YieldCtx>
inline void forwardError(YieldCtx& yield, boost::system::error_code ec) {
    if (!yield.ec_) {
        throw boost::system::system_error(ec);
    }
    *yield.ec_ = std::move(ec);
}

template <typename YieldCtx, typename T>
[[nodiscard]] inline decltype(auto) forwardError(YieldCtx& yield, boost::system::error_code ec, T&& v) {
    forwardError(yield, ec);
    return std::forward<T>(v);
}

} // namespace mbox_oper
