
#include <pa/async.h>
#include <yplatform/reactor/io_pool.h>
#include <macs_pg/logging.h>
#include <user_journal/service_factory.h>
#include <user_journal/profiling.h>
#include <user_journal/logging.h>
#include <mailbox_oper/config.h>
#include <mailbox_oper/errors.h>
#include <mailbox_oper/logger.h>
#include <yamail/data/deserialization/ptree.h>
#include <boost/range/algorithm/transform.hpp>
#include <mail/ymod_maildb/include/module.h>
#include <yplatform/find.h>


namespace mbox_oper {

namespace {

void initPa(const boost::property_tree::ptree& tree) {
    pa::async_profiler::init(500000, 16, tree.get("profiler_log", ""));
}

using MacsPgLog = macs::pg::logging::v2::TypedLog<Logger>;

inline macs::pg::logging::v2::LogPtr getMacsPgLogger() {
    return std::make_shared<MacsPgLog>(getLogger());
}

}


Configuration::Configuration(const boost::property_tree::ptree& tree)
        : tabsMap(macs::deprecated::initTabsMap(tree.get_child("tabs"), "mapping")) {
    const auto logger = getLogger();
    try {
        if( !pa::async_profiler::is_init() ) {
            initPa(tree);
        }

        blackboxEndpoint = http_getter::TypedEndpoint::fromPtree(tree.get_child("blackbox"));
        httpGetter = yplatform::find<http_getter::TypedClientModule, std::shared_ptr>(tree.get<std::string>("dependencies.http_getter"));

        maildb = yplatform::find<ymod_maildb::Module, std::shared_ptr>("maildb");
        pgLog = getMacsPgLogger();

        userInfoStrategy = yamail::data::reflection::from_string<UserInfoStrategy>(
                tree.get("user_info_strategy", "paramsThenBlackbox"));

        LOGDOG_(logger, notice, log::message="Successfully loaded mailbox_oper config");
    } catch (const std::exception& e) {
        LOGDOG_(logger, error, log::message="Exception while loading mailbox_oper config",
                log::exception=e);
        throw;
    }
}

user_journal::ServicePtr Configuration::journalService() const {
    return maildb->userJournalService();
}

}
