#include <mailbox_oper/mailbox_oper_routines.h>
#include <mailbox_oper/get_user_journal.h>
#include <internal/blackbox.h>
#include <internal/update_user_info_params.h>
#include <macs_pg/integration/pa_profiler.h>
#include <macs_pg/macs_pg.h>
#include <mail/ymod_maildb/include/module.h>

namespace mbox_oper {

macs::ServicePtr getMetadata(ConfigurationPtr config, const MailboxOperParams& params) {

    auto serviceParams = ymod_maildb::ServiceParams {
        .uid=params.uid,
        .realIp=params.remoteIp,
        .requestId=params.requestId,
        .module="mailbox_oper"
    };

    auto journalParams = ymod_maildb::UserJournalParams {
        .connectionId=params.connectionId,
        .expBoxes=params.testBuckets,
        .enabledExpBoxes=params.enabledTestBuckets,
        .clientType=params.clientType,
        .clientVersion=params.clientVersion,
        .userAgent=params.userAgent,
        .yandexUid=params.yandexUidCookie,
        .iCookie=params.iCookie,
        .sessionInfo=params.sessionInfo
    };

    return config->maildb->service(std::move(serviceParams), std::move(journalParams), config->pgLog, macs::pg::readMasterThenReplica);
}

namespace log {
LOGDOG_DEFINE_ATTRIBUTE(MailboxOperParams, params)
}

MailboxOper getMailboxOper(ConfigurationPtr config, MailboxOperParams& params, ContextPtr context, YieldCtx yield) {
    const auto& uid = params.uid;
    const auto logger = ::logdog::bind(getContextLogger(context), log::uid=uid);
    auto client = config->httpGetter->create(context, nullptr);

    blackbox::User user = blackbox::userInfo(client, config->blackboxEndpoint, uid, params.remoteIp, logger, yield);
    updateUserInfo(params, user, config->userInfoStrategy);
    LOGDOG_(logger, notice, log::params=std::cref(params));
    if (user.isMailish) {
        throw std::logic_error("mailish user is not supported; uid:" + uid);
    }

    auto journal = getJournal(params, "mailbox_oper", config->journalService());
    auto metadata = getMetadata(config, params);
    auto mailboxModifier = std::make_shared<MailboxModifierMacsImpl>(metadata);

    return MailboxOper(metadata, mailboxModifier, context, journal, config->tabsMap);
}

} // namespace

namespace logdog::tskv {

template<>
struct to_tskv_impl<mbox_oper::MailboxOperParams> {
    template<typename Out>
    static void apply(Out& out, const char* key, const mbox_oper::MailboxOperParams& v) {
        std::string name = key;

        out << ytskv::attr(name + ".login", v.login)
            << ytskv::attr(name + ".karma", v.karma)
            << ytskv::attr(name + ".karma_status", v.karmaStatus);
    }
};

}
