#include <internal/update_user_info_params.h>

namespace mbox_oper {

void updateUserInfo(MailboxOperParams& params, const blackbox::User& userInfo, UserInfoStrategy strategy) {
    const auto notEmpty = [](const std::string& first, const std::string& second) {
        return first.empty() ? second : first;
    };

    switch (strategy) {
        case UserInfoStrategy::paramsOnly:
            return;
        case UserInfoStrategy::paramsThenBlackbox:
            params.login = notEmpty(params.login, userInfo.login);
            params.karma = notEmpty(params.karma, userInfo.karma);
            params.karmaStatus = notEmpty(params.karmaStatus, userInfo.karmaStatus);
            return;
        case UserInfoStrategy::blackboxThenParams:
            params.login = notEmpty(userInfo.login, params.login);
            params.karma = notEmpty(userInfo.karma, params.karma);
            params.karmaStatus = notEmpty(userInfo.karmaStatus, params.karmaStatus);
            return;
        case UserInfoStrategy::blackboxOnly:
            params.login = userInfo.login;
            params.karma = userInfo.karma;
            params.karmaStatus = userInfo.karmaStatus;
            return;
    }
}

}
