#!/bin/bash

export app=mops

source /app/init/service_sh/map_resources_qloud.sh
source /app/init/service_sh/environment_type_qloud.sh
source /app/init/service_sh/ephemerial_qloud.sh
source /app/init/service_sh/push_client_to_ephemerial_qloud.sh push-client-service
source /app/init/service_sh/postgres_qloud.sh
source /app/init/service_sh/tvm_qloud.sh
source /app/init/service_sh/tzdata_qloud.sh
source /app/init/service_sh/ssl_qloud.sh
source /app/init/service_sh/link_push_client_qloud.sh

source /app/init/service_sh/application_links_to_config_and_tvm_root_id.sh
source /app/init/service_sh/unistat_dir.sh
source /app/init/service_sh/link_nginx_config.sh
source /app/init/service_sh/nginx_dirs_and_services.sh

# make 10 attemps in case of any problems
for i in {1..10}; do
    if [[ -d /secrets/ssl ]]; then
        echo "copying crt"
        case "$ENVIRONMENT" in
            production)
                cp -f /secrets/ssl/mops.mail.yandex.net.pem /app/secrets/ssl_cert.pem
                ;;
            intranet-production|corp)
                cp -f /secrets/ssl/mopscorp.mail.yandex.net.pem /app/secrets/ssl_cert.pem
                ;;
            testing|load|prestable|intranet-prestable|corp-prestable)
                cp -f /secrets/ssl/star.mail.yandex.net.pem /app/secrets/ssl_cert.pem
                ;;
            *)
                echo "Unknown environment type: $ENVIRONMENT, cannot start"
                exit 1
                ;;
        esac

        if [[ "$?" != 0 ]]; then
            continue
        fi

        echo "ok"
        break
    else
        echo "No crt, sleeping"
        sleep 5
    fi
done

if [[ "$i" -eq 10 ]]; then
    echo "Cannot start"
    exit 1
fi

# make 10 attemps in case of any problems
for i in {1..10}; do
    if [[ -f /secrets/stoken ]]; then
        echo "copying stoken"
        cp -f /secrets/stoken /app/secrets/stoken

        if [[ "$?" != 0 ]]; then
            continue
        fi

        echo "ok"
        break
    else
        echo "No stoken found, sleeping"
        sleep 5
    fi
done

if [[ "$i" -eq 10 ]]; then
    echo "Failed to chown stoken, cannot start"
    exit 1
fi


if [[ "${QA_ENVIRONMENT}" == "true" ]]; then
    rm /app/config/config.yml

    QLOUD_FULL_ENV=$(echo ${QLOUD_DISCOVERY_COMPONENT} | grep -o -P '(?<=mops.).+')
    MOPS_DB_HOST="mopsdb-1.mopsdb.${QLOUD_FULL_ENV}"

    sed -i -e "1 s#^#${MOPS_DB_HOST}:6432:mopsdb:mops:gavgav\n#;" /root/.pgpass

    sed -e "s#_MOPS_DB_HOST_#${MOPS_DB_HOST}#g" \
        -e "s#_MOPS_ZK_NODE_#/mops-${QLOUD_ENVIRONMENT}#g" \
        -e "s#_MOPS_CALLBACK_HOST_#${QLOUD_HOSTNAME}#g" \
        /app/config/mops-qa-patch.yml > /app/config/config.yml

    ln -sf /app/config/config.yml-${ENVIRONMENT} /app/config/config-base.yml
else
    ln -sf /app/config/config.yml-${ENVIRONMENT} /app/config/config.yml
fi

/usr/bin/supervisord -nc /etc/supervisor/supervisord.conf
