#pragma once

#include <yplatform/log.h>
#include <logdog/logger.h>
#include <logdog/format/tskv.h>
#include <logdog/backend/yplatform_log.h>
#include <mail/mops/include/common/logdog.h>
#include <mail/mops/include/common/context.h>
#include <macs_pg/logging.h>

namespace mops::reply_later {

namespace log {

using namespace ::logdog::attr;
using namespace ::logdog::attr::mail;
using namespace ::mops::logdog;
LOGDOG_DEFINE_ATTRIBUTE(std::string, stickers_mids)
LOGDOG_DEFINE_ATTRIBUTE(int, strange_stickers_count)

constexpr static auto formatter = ::logdog::tskv::make_formatter(BOOST_HANA_STRING("mail-mops-tskv-log"));

}

inline auto getModuleLogger() {
    auto logger = std::make_shared<yplatform::log::source>(yplatform::log::find("mops"));
    return ::logdog::make_log(log::formatter, std::move(logger));
}

using ModuleLogger = decltype(getModuleLogger());

inline auto getContextLogger(const std::string& uid, const std::string& requestId) {
    return ::logdog::bind(getModuleLogger(), log::uid=uid, log::x_request_id=requestId);
}

using ContextLogger = decltype(getContextLogger("", ""));

using MacsPgLog = macs::pg::logging::v2::TypedLog<ContextLogger>;

}
