#pragma once

#include <mail/webmail/http_api_helpers/include/response.h>
#include <mail/webmail/http_api_helpers/include/context.h>
#include <mail/mops/reply_later/service/include/result.h>
#include <mail/mops/reply_later/core/include/log.h>

namespace mops::reply_later {

class Response: public http_api::Response {
    static ContextLogger createLog(const ymod_webserver::response_ptr& stream) {
        http_api::Context ctx{stream->request()};
        std::string uid = ctx.optionalArg("uid").value_or("");
        std::string requestId = ctx.optionalHeader("x-request-id").value_or("");
        return getContextLogger(uid, requestId);
    }

public:
    Response(ContextLogger l, ymod_webserver::response_ptr s)
        : http_api::Response(std::move(s))
        , log(std::move(l))
    { }

    Response(ymod_webserver::response_ptr s)
        : http_api::Response(std::move(s))
        , log(createLog(stream))
    { }

    using http_api::Response::with;
    void with(EmptyResult&& resp) const;

private:
    void logErrorResponse(const std::string& body) const override;
    void logSuccessResponse(const std::string& body) const override;
    bool errorCodeToResponseCode(const mail_errors::error_code& ec, ymod_webserver::codes::code& code) const override;

    ContextLogger log;
};

}