#include <mail/mops/reply_later/http_api/include/parse.h>
#include <yamail/data/deserialization/urlencoded_reader.h>

namespace mops::reply_later {

CommonParams parseCommonParams(const http_api::Context& ctx) {
    CommonParams result;

    result.uid = ctx.arg("uid");
    result.requestId = ctx.optionalHeader("x-request-id").value_or("");

    return result;
}

namespace ydd = yamail::data::deserialization;

namespace {

template <class T>
inline auto wrap(T&& fn) {
    try {
        fn();
    } catch (const ydd::urlencoded::ReaderException& ex) {
        http_api::Context::throwMissingParamException(ex.what());
    }
}

template <class Type>
Type parse(const http_api::Context& ctx) {
    Type variableToFill;
    const auto extractOneArg   = [&] (auto&& name) { return ctx.optionalArg(name);  };
    const auto extractManyArgs = [&] (auto&& name) { return ctx.optionalArgs(name); };

    wrap([&] () {
        ydd::fromUrlencoded(variableToFill, extractOneArg, extractManyArgs);
    });

    return variableToFill;
}
}

CreateReplyLaterParams parseCreateReplyLaterParams(const http_api::Context& ctx) {
    return parse<CreateReplyLaterParams>(ctx);
}

RemoveReplyLaterParams parseRemoveReplyLaterParams(const http_api::Context& ctx) {
    return parse<RemoveReplyLaterParams>(ctx);
}

CallbackReplyLaterParams parseCallbackReplyLaterParams(const http_api::Context& ctx) {
    return parse<CallbackReplyLaterParams>(ctx);
}

UpdateReplyLaterParams parseUpdateReplyLaterParams(const http_api::Context& ctx) {
    return parse<UpdateReplyLaterParams>(ctx);
}

ResetReplyLaterParams parseResetReplyLaterParams(const http_api::Context& ctx) {
    return parse<ResetReplyLaterParams>(ctx);
}

}

YREFLECTION_ADAPT_ADT(mops::reply_later::CreateReplyLaterParams,
    YREFLECTION_MEMBER(macs::Mid, mid)
    YREFLECTION_MEMBER(std::time_t, date)
)

YREFLECTION_ADAPT_ADT(mops::reply_later::RemoveReplyLaterParams,
    YREFLECTION_MEMBER(macs::Mid, mid)
)

YREFLECTION_ADAPT_ADT(mops::reply_later::CallbackReplyLaterParams,
    YREFLECTION_MEMBER(macs::Mid, mid)
    YREFLECTION_MEMBER(macs::Fid, fid)
    YREFLECTION_MEMBER(std::optional<macs::Tab::Type>, tab)
    YREFLECTION_MEMBER(std::time_t, date)
)

YREFLECTION_ADAPT_ADT(mops::reply_later::UpdateReplyLaterParams,
    YREFLECTION_MEMBER(macs::Mid, mid)
    YREFLECTION_MEMBER(std::time_t, date)
)

YREFLECTION_ADAPT_ADT(mops::reply_later::ResetReplyLaterParams,
    YREFLECTION_MEMBER(macs::Mid, mid)
    YREFLECTION_MEMBER(std::time_t, date)
)
