#include <mail/mops/reply_later/http_api/include/response.h>
#include <mail/mops/reply_later/service/include/errors.h>
#include <macs/errors.h>


BOOST_FUSION_ADAPT_STRUCT(mops::reply_later::EmptyResult, )

namespace mops::reply_later {

void Response::with(EmptyResult&& resp) const {
    defaultJsonResponse(std::move(resp));
}

void Response::logErrorResponse(const std::string& body) const {
    LOGDOG_(log, error, log::where_name=stream->request()->url.make_full_path(), log::message=body);
}

void Response::logSuccessResponse(const std::string& body) const {
    LOGDOG_(log, notice, log::where_name=stream->request()->url.make_full_path(), log::message=body);
}

bool Response::errorCodeToResponseCode(const mail_errors::error_code& ec, ymod_webserver::codes::code& code) const {
    if (ec.category() == getServiceCategory()) {
        switch(ServiceError(ec.value())) {
            case ServiceError::replyLaterFolderDoesNotExist:
            case ServiceError::envelopeAlreadyInReplyLaterFolder:
            case ServiceError::envelopeIsNotInReplyLaterFolder:
            case ServiceError::replyLaterStickerDoesNotExist:
            case ServiceError::envelopeHasNotReplyLaterStartedLabel:
                code = ymod_webserver::codes::bad_request; break;
            case ServiceError::callmebackError:
            case ServiceError::unexpectedException:
                code = ymod_webserver::codes::internal_server_error; break;
            case ServiceError::callbackEnvelopeIsNotInReplyLaterFolder:
            case ServiceError::callbackEnvelopeHasNotReplyLaterStartedLabel:
            case ServiceError::callbackReplyLaterStickerDoesNotExist:
            case ServiceError::callbackEnvelopeDoesNotExist:
            case ServiceError::callbackMiss:
                code = ymod_webserver::codes::ok; break;
        }
        return true;
    } else if (ec.category() == macs::error::getCategory()) {
        switch(macs::error::Errors(ec.value())) {
            case macs::error::Errors::stickerDateOutOfInterval:
                code = ymod_webserver::codes::bad_request;
                return true;
            default:
                return false;
        }
    }
    return false;
}

}
