#include <mail/mops/reply_later/service/include/errors.h>

namespace mops::reply_later {

std::string ServiceCategory::message(int v) const {
    switch(ServiceError(v)) {
        case ServiceError::unexpectedException:
            return "unexpected exception";
        case ServiceError::replyLaterFolderDoesNotExist:
            return "reply_later folder does not exist";
        case ServiceError::envelopeAlreadyInReplyLaterFolder:
            return "envelope already in reply_later folder";
        case ServiceError::envelopeIsNotInReplyLaterFolder:
        case ServiceError::callbackEnvelopeIsNotInReplyLaterFolder:
            return "envelope is not in reply_later folder";
        case ServiceError::replyLaterStickerDoesNotExist:
        case ServiceError::callbackReplyLaterStickerDoesNotExist:
            return "reply_later sticker does not exist on this envelope";
        case ServiceError::envelopeHasNotReplyLaterStartedLabel:
        case ServiceError::callbackEnvelopeHasNotReplyLaterStartedLabel:
            return "envelope has not reply_later_started label";
        case ServiceError::callbackEnvelopeDoesNotExist:
            return "envelope does not exist";
        case ServiceError::callmebackError:
            return "callmeback error";
        case ServiceError::callbackMiss:
            return "callback miss";
    }
    return "unknown enum code";
}

const ServiceCategory& getServiceCategory() {
    static ServiceCategory instance;
    return instance;
}

mail_errors::error_code::base_type make_error_code(ServiceError e) {
    return mail_errors::error_code::base_type(static_cast<int>(e), getServiceCategory());
}

mail_errors::error_code make_error(ServiceError e, std::string what) {
    return mail_errors::error_code(e, std::move(what));
}

}
