#pragma once

#include <mail/mail_errors/include/mail_errors/error_code.h>
#include <yamail/expected.h>

namespace mops::reply_later {

enum class ServiceError {
    unexpectedException = 1,
    replyLaterFolderDoesNotExist,
    envelopeAlreadyInReplyLaterFolder,
    envelopeIsNotInReplyLaterFolder,
    callbackEnvelopeIsNotInReplyLaterFolder,
    replyLaterStickerDoesNotExist,
    callbackReplyLaterStickerDoesNotExist,
    envelopeHasNotReplyLaterStartedLabel,
    callbackEnvelopeHasNotReplyLaterStartedLabel,
    callbackEnvelopeDoesNotExist,
    callmebackError,
    callbackMiss,
};

struct ServiceCategory: public mail_errors::error_code::error_category {
    const char* name() const noexcept override {
        return "service";
    }

    std::string message(int v) const override;
};

const ServiceCategory& getServiceCategory();
mail_errors::error_code::base_type make_error_code(ServiceError e);
mail_errors::error_code make_error(ServiceError e, std::string what="");
inline auto make_unexpected(ServiceError e, std::string what="") {
    return yamail::make_unexpected(make_error(e, std::move(what)));
}

}

namespace boost::system {
template <>
struct is_error_code_enum<mops::reply_later::ServiceError> : std::true_type { };
}
