#pragma once

#include <boost/asio/spawn.hpp>
#include <macs/types.h>
#include <yamail/expected.h>
#include <mail/mops/reply_later/core/include/types.h>
#include <mail/mops/reply_later/service/include/config.h>
#include <mail/mops/reply_later/service/include/result.h>
#include <mail/mops/reply_later/service/include/request_context.h>


namespace mops::reply_later {

struct CreateReplyLaterParams {
    macs::Mid mid;
    std::time_t date;
};

yamail::expected<CreateReplyLaterResult> createReplyLater(CommonParams common, CreateReplyLaterParams params,
        RequestContext req, macs::ServicePtr service, ConfigPtr cfg, boost::asio::yield_context yield);

struct RemoveReplyLaterParams {
    macs::Mid mid;
};

yamail::expected<RemoveReplyLaterResult> removeReplyLater(CommonParams common, RemoveReplyLaterParams params,
        RequestContext req, macs::ServicePtr service, ConfigPtr cfg, boost::asio::yield_context yield);

struct CallbackReplyLaterParams {
    macs::Mid mid;
    macs::Fid fid;
    std::optional<macs::Tab::Type> tab;
    std::time_t date;
};

yamail::expected<CallbackReplyLaterResult> callbackReplyLater(CommonParams common, CallbackReplyLaterParams params,
        RequestContext req, macs::ServicePtr service, ConfigPtr cfg, boost::asio::yield_context yield);

struct UpdateReplyLaterParams {
    macs::Mid mid;
    std::time_t date;
};

yamail::expected<UpdateReplyLaterResult> updateReplyLater(CommonParams common, UpdateReplyLaterParams params,
        RequestContext req, macs::ServicePtr service, ConfigPtr cfg, boost::asio::yield_context yield);

struct ResetReplyLaterParams {
    macs::Mid mid;
    std::time_t date;
};

yamail::expected<ResetReplyLaterResult> resetReplyLater(CommonParams common, ResetReplyLaterParams params,
        RequestContext req, macs::ServicePtr service, ConfigPtr cfg, boost::asio::yield_context yield);

}
