#pragma once

#include <mail/mops/reply_later/core/include/log.h>
#include <mail/mops/reply_later/core/include/types.h>
#include <mail/http_getter/client/include/client.h>


namespace mops::reply_later {

struct RequestContext {
    http_getter::TypedClientPtr httpClient;
    ContextLogger logger;

    RequestContext(http_getter::TypedClientPtr clt, const CommonParams& common)
        : httpClient(std::move(clt))
        , logger(getContextLogger(common.uid, common.requestId))
    { }
};

}
