
#include <yplatform/module_registration.h>
#include <internal/server/server.h>
#include <internal/logger.h>
#include <internal/module.h>
#include <internal/tvm_guard.h>
#include <tvm_guard/tvm_guard.h>

namespace mbox_oper {

void MopsModule::init(const yplatform::ptree&) {
    const auto tvmGuard = yplatform::find<tvm_guard::Module, std::shared_ptr>("tvm_guard");
    bindServerHandlers(*tvmGuard);
    LOGDOG_(log, notice, log::message="mops module initialized");
}

void MopsModule::reload(const yplatform::ptree&) {
    LOGDOG_(log, notice, log::message="mops module reloaded");
}

void MopsModule::start() {
    LOGDOG_(log, notice, log::message="mops module started");
}

void MopsModule::stop() {
    LOGDOG_(log, notice, log::message="mops module stopped");
}

void MopsModule::fini() {
    LOGDOG_(log, notice, log::message="mops module finished");
}

}

DEFINE_SERVICE_OBJECT(mbox_oper::MopsModule)
