#include <mailbox_oper/mailbox_oper_routines.h>
#include <internal/server/parse_params.h>
#include <internal/server/output_reflection.h>
#include <internal/server/handlers/folders/create_handler.h>

namespace mbox_oper {

static constexpr bool defaultStrict = true;

static macs::Folder::Symbol getSymbol(RequestContext& req) {
    const auto symbol = req.getArgOptional("symbol");
    if (symbol) {
        const auto folderSymbol = macs::Folder::Symbol::getByTitle(*symbol);
        if (folderSymbol == macs::Folder::Symbol::none) {
            throw ParamsException("no such symbol");
        }
        return folderSymbol;
    } else {
        return macs::Folder::Symbol::none;
    }
}

static bool getStrict(RequestContext& req) {
    return req.getArgOptionalBool("strict").get_value_or(defaultStrict);
}

void FolderCreateHandler::execute(RequestContext& req, YieldCtx yield) const {
    const std::string name = req.getArgOrThrow("name");
    const auto parentFid = req.getArgOrValue("parent_fid", macs::Folder::noParent);
    const auto symbol = getSymbol(req);
    const bool strict = getStrict(req);

    MailboxOperParams commonParams = parseCommonParams(req);

    auto mailboxOper = moperModule_->api(commonParams, req.context(), yield);

    const auto newFolder = strict ?
            mailboxOper.createFolder(name, parentFid, symbol, yield)
            : mailboxOper.getOrCreateFolder(name, parentFid, symbol, yield);

    const FolderReflection folder(newFolder);
    req.responseSuccess(toString(folder));
}

} // namespace mbox_oper
