#include <internal/server/parse_params.h>
#include <internal/server/output_reflection.h>
#include <internal/server/handlers/folders/create_hidden_trash_handler.h>

namespace mbox_oper {

void FolderCreateHiddenTrashHandler::execute(RequestContext& req, YieldCtx yield) const {
    MailboxOperParams commonParams = parseCommonParams(req);
    auto mailboxOper = moperModule_->api(commonParams, req.context(), yield);

    const auto newFolder = mailboxOper.getOrCreateFolderBySymbolWithRandomizedName("hidden_trash",
            macs::Folder::noParent, macs::Folder::Symbol::hidden_trash, true, yield);

    const FolderReflection folder(newFolder);
    req.responseSuccess(toString(folder));
}

} // namespace mbox_oper
