#include <mailbox_oper/mailbox_oper_routines.h>
#include <internal/server/parse_params.h>
#include <internal/server/output_reflection.h>
#include <internal/server/handlers/folders/update_handler.h>

namespace mbox_oper {

void FolderUpdateHandler::doUpdate(
        MailboxOper& mailboxOper, const RequestContext& req, YieldCtx yield) const {
    const auto fid = req.getArgOrThrow("fid");
    const auto name = req.getArgOptional("name");
    const auto parentFid = req.getArgOrValue("parent_fid", macs::Folder::noParent);
    mailboxOper.updateFolder(fid, name, parentFid, yield);
}

} // namespace mbox_oper
