#include <mailbox_oper/mailbox_oper_routines.h>
#include <internal/server/parse_params.h>
#include <internal/server/output_reflection.h>
#include <internal/server/handlers/folders/update_position_handler.h>

namespace mbox_oper {

void FolderUpdatePositionHandler::doUpdate(MailboxOper& mailboxOper, const RequestContext& req,
                                           YieldCtx yield) const {
    const std::string fid = req.getArgOrThrow("fid");
    const std::string prevFid = req.getArgOrValue("prev_fid", macs::Folder::noParent);
    mailboxOper.setSortOptions(fid, prevFid, yield);
}

} // namespace mbox_oper
