#include <mailbox_oper/mailbox_oper_routines.h>
#include <internal/server/parse_params.h>
#include <internal/server/handlers/folders/update_symbol_handler.h>

namespace mbox_oper {

void FolderUpdateSymbolHandler::doUpdate(MailboxOper& mailboxOper, const RequestContext& req,
                                         YieldCtx yield) const {
    const std::string fid = req.getArgOrThrow("fid");
    const std::string symbol = req.getArg("symbol");
    mailboxOper.setFolderSymbol(fid, symbol, yield);
}

}
