#include <mailbox_oper/mailbox_oper_routines.h>
#include <internal/server/parse_params.h>
#include <internal/server/output_reflection.h>
#include <internal/server/handlers/labels/create_handler.h>
#include <macs/label.h>

namespace mbox_oper {


static constexpr bool defaultStrict = true;

static bool getStrict(RequestContext& req) {
    return req.getArgOptionalBool("strict").get_value_or(defaultStrict);
}

void LabelCreateHandler::execute(RequestContext& req, YieldCtx yield) const {
    const OptString symbol = req.getArgOptional("symbol");
    const OptString name = req.getArgOptional("name");
    const std::string color = req.getArg("color");
    const std::string type = req.getArg("type");

    if (symbol && (name || color.size() || type.size())) {
        throw ParamsException("wrong combination of params: you can create label either by symbol or by name + color + type");
    }

    if (!symbol && type == "system") {
        throw ParamsException("wrong combination of params: you must specify symbol on creating system label");
    }

    MailboxOperParams commonParams = parseCommonParams(req);
    auto mailboxOper = moperModule_->api(commonParams, req.context(), yield);
    const bool strict = getStrict(req);

    macs::Label newLabel;

    if (symbol) {
        newLabel = strict ? mailboxOper.createLabel(*symbol, yield)
                            : mailboxOper.getOrCreateLabel(*symbol, yield);
    } else if (name) {
        newLabel = strict ? mailboxOper.createLabel(*name, color, type, yield)
                            : mailboxOper.getOrCreateLabel(*name, color, type, yield);
    } else {
        throw ParamsException("Need any of these parameters: symbol, name");
    }

    const LabelReflection label(newLabel);
    req.responseSuccess(toString(label));
}

} // namespace mbox_oper
