#include <mailbox_oper/mailbox_oper_routines.h>
#include <internal/server/parse_params.h>
#include <internal/server/output_reflection.h>
#include <internal/server/handlers/labels/update_handler.h>

namespace mbox_oper {

void LabelUpdateHandler::doUpdate(MailboxOper& mailboxOper, const RequestContext& req,
        YieldCtx yield) const {
    const auto lid = req.getArgOrThrow("lid");
    const auto name = req.getArgOptional("name");
    const auto color = req.getArgOptional("color");
    mailboxOper.updateLabel(lid, color, name, yield);
}

} // namespace mbox_oper
