#include <internal/server/handlers/operations/purge_hidden_trash_handler.h>

#include <internal/async_api.h>
#include <internal/server/parse_params.h>

namespace mbox_oper {

const std::string mail_b2b_admin_search_enabled = "mail_b2b_admin_search_enabled";

void PurgeHiddenTrashHandler::execute(RequestContext& req, YieldCtx yield) const {
    MailboxOperParams commonParams = parseCommonParams(req);
    MailboxOper moperApi = moperModule_->api(commonParams, req.context(), yield);

    auto fid = moperApi.meta().getFid(macs::Folder::Symbol::hidden_trash, yield);
    if (fid == Fid{}) {
        req.responseInvalidRequest("folder with symbol hidden_trash wasn't found");
        return;
    }

    const auto settings = moperApi.meta().getParameters({mail_b2b_admin_search_enabled}, yield);
    const auto it = settings->single_settings.find(mail_b2b_admin_search_enabled);
    if (it != settings->single_settings.end() && it->second == "on") {
        req.responseSuccess();
        return;
    }

    auto source = createFidSource(std::move(fid), req);
    auto params = ParamsTraits<PurgeParams>::parse(req);

    if (const auto validationError = source->validate()) {
        logError(req, validationError.get());
        throw ParamsException(validationError.get());
    }

    MailboxOperAsyncApi asyncApi(moperApi, commonParams, req.context());
    const auto res = asyncApi.execute<ymod_taskmaster::PurgeTask>(std::move(params), std::move(source), yield);
    req.responseSuccess(res);
}

}
