#include <ymod_taskmaster/service.hpp>
#include <ymod_taskmaster/marshalling.hpp>
#include <internal/server/handlers/stat_handler.h>

namespace mbox_oper {

void StatHandler::execute(RequestContext& req, YieldCtx yield) const {
    const std::string uid = req.getArg("uid");
    if (uid.empty()) {
        throw ParamsException("empty uid parameter");
    }
    ymod_taskmaster::ServicePtr taskMaster = yplatform::find<ymod_taskmaster::Service, std::shared_ptr>("task_master");
    const ymod_taskmaster::UserStat stat = taskMaster->getUserStat(uid, req.context(), yield);
    req.responseSuccess(toString(stat));
}


} // namespace mbox_oper
