
#include <yplatform/find.h>
#include <ymod_webserver/server.h>

#include <internal/server/server.h>
#include <internal/server/handlers/stat_handler.h>

#include <internal/server/handlers/operations/spam_handler.h>
#include <internal/server/handlers/operations/unspam_handler.h>
#include <internal/server/handlers/operations/purge_handler.h>
#include <internal/server/handlers/operations/purge_hidden_trash_handler.h>
#include <internal/server/handlers/operations/remove_handler.h>
#include <internal/server/handlers/operations/complex_move_handler.h>
#include <internal/server/handlers/operations/mark_handler.h>
#include <internal/server/handlers/operations/label_handler.h>
#include <internal/server/handlers/operations/unlabel_handler.h>

#include <internal/server/handlers/folders/create_handler.h>
#include <internal/server/handlers/folders/create_hidden_trash_handler.h>
#include <internal/server/handlers/folders/update_handler.h>
#include <internal/server/handlers/folders/update_symbol_handler.h>
#include <internal/server/handlers/folders/update_position_handler.h>
#include <internal/server/handlers/folders/delete_handler.h>
#include <internal/server/handlers/folders/update_pop3_handler.h>

#include <internal/server/handlers/labels/create_handler.h>
#include <internal/server/handlers/labels/update_handler.h>
#include <internal/server/handlers/labels/delete_handler.h>

namespace mbox_oper {

template<typename T>
void bindServerHandler(const tvm_guard::Module& guard) {
    auto handler = std::make_shared<T>();
    auto server = yplatform::find<ymod_webserver::server>("web_server");
    std::string path = "/" + handler->name();

    guard.bind(*server, "", { std::move(path) }, [handler = std::move(handler)] (ymod_webserver::response_ptr resp) {
        handler->process(std::move(resp));
    });
}

void bindServerHandlers(const tvm_guard::Module& guard) {
    bindServerHandler<StatHandler>(guard);

    bindServerHandler<SpamHandler>(guard);
    bindServerHandler<UnspamHandler>(guard);
    bindServerHandler<PurgeHandler>(guard);
    bindServerHandler<PurgeHiddenTrashHandler>(guard);
    bindServerHandler<RemoveHandler>(guard);
    bindServerHandler<ComplexMoveHandler>(guard);
    bindServerHandler<MarkHandler>(guard);
    bindServerHandler<LabelHandler>(guard);
    bindServerHandler<UnlabelHandler>(guard);

    bindServerHandler<FolderCreateHandler>(guard);
    bindServerHandler<FolderCreateHiddenTrashHandler>(guard);
    bindServerHandler<FolderUpdateHandler>(guard);
    bindServerHandler<FolderUpdateSymbolHandler>(guard);
    bindServerHandler<FolderUpdatePositionHandler>(guard);
    bindServerHandler<FolderDeleteHandler>(guard);
    bindServerHandler<FolderUpdatePop3Handler>(guard);

    bindServerHandler<LabelCreateHandler>(guard);
    bindServerHandler<LabelUpdateHandler>(guard);
    bindServerHandler<LabelDeleteHandler>(guard);
}

}
