#pragma once

#include <logdog/logger.h>
#include <logdog/format/tskv.h>
#include <logdog/backend/yplatform_log.h>
#include <ymod_taskmaster/marshalling.hpp>
#include <mail/mops/include/common/logdog.h>

namespace mops_worker {
namespace log {

using namespace ::mops::logdog;

LOGDOG_DEFINE_ATTRIBUTE(std::size_t, stack_size)
LOGDOG_DEFINE_ATTRIBUTE(std::string, launch_id)
LOGDOG_DEFINE_ATTRIBUTE(ymod_taskmaster::ChunkData, chunk)
LOGDOG_DEFINE_ATTRIBUTE(ymod_taskmaster::ChunkId, chunk_id)

constexpr static auto formatter = ::logdog::tskv::make_formatter(BOOST_HANA_STRING("mail-mops-worker-tskv-log"));

} // namespace log

inline auto getLogger(const std::string& name) {
    return ::logdog::make_log(log::formatter,
            std::make_shared<yplatform::log::source>(YGLOBAL_LOG_SERVICE, name)
    );
}

using Logger = decltype(getLogger(""));

} // namespace mops_worker

namespace logdog::tskv {

template <>
struct to_tskv_impl<ymod_taskmaster::ChunkData> {
    template <typename Out>
    static void apply(Out& out, const char* key, const ymod_taskmaster::ChunkData& v) {
        const std::string name = key;
        out << ytskv::attr(logdog::name(::mops_worker::log::uid), v.task.taskData.commonParams.uid)
            << ytskv::attr(name + ".type", ymod_taskmaster::toString(v.task.taskData.type))
            << ytskv::attr(name + ".data", ymod_taskmaster::toString(v));
    }
};

}
