#pragma once

#include <atomic>
#include <ymod_taskmaster/service.hpp>
#include <mailbox_oper/yield_context.h>
#include <ymod_mops_worker/logger.h>
#include <ymod_mops_worker/context.h>
#include <mail/webmail/task_context/include/task_context_holder.h>
#include <ymod_mops_worker/config.h>

namespace mops_worker {

struct TaskContext: public yplatform::task_context {
    using yplatform::task_context::task_context;

    TaskContext(const yplatform::task_context& other)
        : yplatform::task_context(other)
    { }

    const std::string& get_name() const override {
        static const std::string name = "mops_worker::task_context";
        return name;
    }
};
using ContextHolder = task_context::ContextHolder<TaskContext>;

class ThreadWorker {
public:
    ThreadWorker(const Configuration& config,
                 const ContextHolder& holder);
    void operator()(boost::asio::yield_context yield);
private:
    bool waitToContinue(boost::asio::yield_context yield) const;
    void process(const ymod_taskmaster::ChunkData& data, ContextPtr context, mbox_oper::YieldCtx) const;

    auto makeContextLogger(ContextPtr context) const {
        return log::makeContextLogger(getLogger(config_.loggerName), std::move(context));
    }

    const Configuration& config_;
    ContextHolder holder_;
    std::string launchId_;
};

} // namespace mops_worker
