#include <yplatform/module.h>
#include <yplatform/module_registration.h>
#include <ymod_mops_worker/config.h>
#include <ymod_mops_worker/thread_worker.h>
#include <mail/webmail/http_api_helpers/include/find_dependency.h>
#include <mail/webmail/ymod_switchbox/include/module.h>
#include <mail/webmail/ymod_healthcheck/include/healthcheck.h>

namespace mops_worker {

struct WorkerModule: public yplatform::module {
    void init(const yplatform::ptree& tree) {
        using namespace http_api;

        config = Configuration {
            .sleepTime=ymod_taskmaster::Seconds(tree.get<unsigned>("sleep_secs")),
            .reactor=findDependency<yplatform::reactor>(tree, "dependencies.reactor"),
            .taskMaster=findDependency<ymod_taskmaster::Service>(tree, "dependencies.task_master"),
            .attributes=boost::coroutines::attributes(tree.get<unsigned>("coroutine_stack_size")),
            .loggerName=tree.get<std::string>("dependencies.logger"),
            .switchbox=findDependency<ymod_switchbox::ModuleProvider>(tree, "dependencies.switchbox"),
            .pauseName=tree.get<std::string>("pause_worker_name"),
        };

        LOGDOG_(getLogger(config.loggerName), notice, log::message="Successfully loaded mops_worker config");
    }

    void start() {
        for (std::size_t i = 0; i < config.reactor->size(); i++) {
            boost::asio::spawn(*config.reactor->io(),
                               [this, self=shared_from_this()] (boost::asio::yield_context yield) {
                ThreadWorker(config, holder)(yield);
            }, config.attributes);
        }
    }

    void stop() {
        holder.cancel();
    }

    yplatform::ptree get_stats() const override {
        return config.switchbox->getValue(config.pauseName) ? ymod_healthcheck::Healthcheck::alive()
                                                           : ymod_healthcheck::Healthcheck::ready();
    }

    Configuration config;
    ContextHolder holder;
};

}

DEFINE_SERVICE_OBJECT(mops_worker::WorkerModule)
