#pragma once

#include <internal/chunk.hpp>

#include <internal/chunks_storage_pg.hpp>
#include <internal/logger.hpp>

namespace ymod_taskmaster {

class ChunksRepositoryImpl : public ChunksRepository {
public:
    ChunksRepositoryImpl(RepositoryPtr pgRequest, ContextPtr context, const size_t pgRetries,
                         Milliseconds pgRetryDelay, Seconds chunkTtl);
    virtual ~ChunksRepositoryImpl() = default;

    ProcessChunkResult processChunk(const User& user, const ChunkId& chunkId, ChunkHandler handler,
                                    YieldCtx yieldCtx) override;
    ChunkIds chooseChunkIds(const User& user, size_t limit, YieldCtx yieldCtx) override;

private:
    ContextLogger logger;
    ContextPtr context;
    ChunksStoragePg pgRepo;
};

}
