#pragma once

#include <ymod_taskmaster/types.hpp>
#include <internal/logger.hpp>
#include <internal/user.hpp>
#include <internal/chunk.hpp>
#include <mail/mops/ymod_taskmaster/ymod_db/include/repository.h>

namespace ymod_taskmaster {

class ChunksStoragePg {
public:
    ChunksStoragePg(RepositoryPtr pgRequest, ContextPtr context, const size_t maxRetries, Milliseconds retryDelay,
                    Seconds chunkTtl);
    Chunks readChunksByMids(const User& user, const Mids& mids, YieldCtx yieldCtx);
    ChunkIds chooseChunkIds(const User& user, size_t limit, YieldCtx yieldCtx);
    Chunks readChunks(const User& user, const ChunkIds& chunkIds, YieldCtx yieldCtx);
    ProcessChunkResult processChunk(const User& user, const ChunkId& chunkId, ChunkHandler handler,
                                    YieldCtx yieldCtx);

private:
    void removeChunk(const User& user, const ChunkId& chunkId, YieldCtx yieldCtx);    

    RepositoryPtr pgRequest_;
    ContextLogger logger_;
    ContextPtr context_;
    size_t maxRetries_;
    Milliseconds retryDelay_;
    Seconds chunkTtl_;
};

} // namespace
