#pragma once

#include <ymod_taskmaster/types.hpp>
#include <pgg/chrono.h>
#include <mail/http_getter/client/include/module.h>

namespace ymod_taskmaster {

struct QueueSettings {
    size_t mids_for_async;
    size_t chunk_size;
    size_t max_mids_to_resolve;
    std::chrono::microseconds lock_timeout;
    size_t chunks_portion_size;
    size_t tasks_limit;
    size_t pg_retries;
    Milliseconds pg_retry_delay;
    size_t choose_users_limit;
    size_t choose_chunks_limit;
    Days chunk_ttl_days;
};

struct NotifySettings {
    std::string stoken_path;
    std::string stoken;
    http_getter::TypedClientPtr httpClient;
    http_getter::TypedEndpoint endpoint;
};

struct Settings {
    QueueSettings queue;
    NotifySettings notify;
};

} // namespace ymod_taskmaster
