#pragma once

#include <internal/config.hpp>
#include <yamail/data/reflection.h>

#define MEMBER_DURATION(duration, name)\
    (name, std::int64_t, std::int64_t, (obj.name.count()), (obj.name = duration(val)))

#define MEMBER_MILLISECONDS(name) MEMBER_DURATION(ymod_taskmaster::Milliseconds, name)
#define MEMBER_PGG_MILLISECONDS(name) MEMBER_DURATION(pgg::Milliseconds, name)

#define MEMBER_UNIT_DURATION(duration, name)\
    (name, std::string, std::string, (::yreflection::to_string(obj.name)), (obj.name = ::yreflection::from_string<duration>(val)))

YREFLECTION_ADAPT_ADT(ymod_taskmaster::QueueSettings,
    YREFLECTION_MEMBER(size_t, mids_for_async)
    YREFLECTION_MEMBER(size_t, chunk_size)
    YREFLECTION_MEMBER(size_t, max_mids_to_resolve)
    MEMBER_UNIT_DURATION(std::chrono::microseconds, lock_timeout)
    YREFLECTION_MEMBER(size_t, chunks_portion_size)
    YREFLECTION_MEMBER(size_t, tasks_limit)
    YREFLECTION_MEMBER(size_t, pg_retries)
    MEMBER_MILLISECONDS(pg_retry_delay)
    YREFLECTION_MEMBER(size_t, choose_users_limit)
    YREFLECTION_MEMBER(size_t, choose_chunks_limit)
    MEMBER_DURATION(ymod_taskmaster::Days, chunk_ttl_days)
)

YREFLECTION_ADAPT_ADT(ymod_taskmaster::NotifySettings,
    YREFLECTION_MEMBER(std::string, stoken_path)
)

BOOST_FUSION_ADAPT_STRUCT(ymod_taskmaster::Settings,
    (ymod_taskmaster::QueueSettings, queue)
    (ymod_taskmaster::NotifySettings, notify)
)

#undef MEMBER_DURATION
#undef MEMBER_MILLISECONDS
#undef MEMBER_PGG_MILLISECONDS
#undef MEMBER_UNIT_DURATION
