#pragma once

#include <boost/property_tree/ptree.hpp>
#include <internal/tasks_repository.hpp>
#include <internal/queue.hpp>
#include <internal/config.hpp>

namespace ymod_taskmaster {

class Notifier {
public:
    Notifier(TasksRepositoryPtr tasksRepo, ContextPtr context, const NotifySettings& settings)
        : tasksRepo_(std::move(tasksRepo)), logger_(getContextLogger(context))
        , context_(std::move(context)), settings_(settings)
    {}

    void notify(const User& user, const Chunk& chunk, YieldCtx yieldCtx);

private:
    TasksRepositoryPtr tasksRepo_;
    ContextLogger logger_;
    ContextPtr context_;
    NotifySettings settings_;
};

typedef boost::shared_ptr<Notifier> NotifierPtr;

} // namespace
