#pragma once

#include <string>
#include <vector>

#include <ymod_taskmaster/types.hpp>
#include <ymod_taskmaster/task.hpp>
#include <internal/logger.hpp>

#include <mail/mops/ymod_taskmaster/ymod_db/include/repository.h>

namespace ymod_taskmaster {

struct QueueSettings;
struct NotifySettings;

class Queue {
public:
    virtual ~Queue() = default;

    virtual bool isAsync(size_t midsCount) const = 0;
    //Post asynchronous task for deferred processing.
    //Returns task id.
    virtual TaskGroupId pushTask(TaskPtr task, const Mids& mids, YieldCtx yieldCtx) = 0;
    virtual bool processChunk(ChunkHandler handler, const std::string& launchId, YieldCtx yieldCtx) = 0;

    virtual UserStat userStat(const UserId& uid, YieldCtx yieldCtx) = 0;
    virtual TaskStatParams readTask(const UserId& uid, const TaskId& taskId, YieldCtx yieldCtx) = 0;
};

using QueuePtr = boost::shared_ptr<Queue>;

QueuePtr getQueue(const QueueSettings& settings, RepositoryPtr pgRepo,
        ContextPtr context, const NotifySettings& notifySettings);

}
