#pragma once

#include <internal/queue.hpp>
#include <internal/user.hpp>
#include <internal/chunk.hpp>
#include <internal/tasks_repository.hpp>
#include <internal/notify.hpp>

namespace ymod_taskmaster {

class QueueImpl : public Queue {
public:
    QueueImpl(const QueueSettings& settings, UsersRepositoryPtr usersRepo,
        ChunksRepositoryPtr chunksRepo, TasksRepositoryPtr tasksRepo, ContextPtr context, NotifierPtr notifier);

    bool isAsync(size_t midsCount) const override;

    TaskGroupId pushTask(TaskPtr task, const Mids& mids, YieldCtx yieldCtx) override;
    bool processChunk(ChunkHandler handler, const std::string& launchId, YieldCtx yieldCtx) override;
    UserStat userStat(const UserId& uid, YieldCtx yieldCtx) override;
    TaskStatParams readTask(const UserId& uid, const TaskId& taskId, YieldCtx yieldCtx) override;
private:
    UserChunk chooseChunkAndHandle(ChunkHandler handler, const std::string& launchId, YieldCtx yieldCtx);

    QueueSettings settings;
    UsersRepositoryPtr usersRepo;
    ChunksRepositoryPtr chunksRepo;
    TasksRepositoryPtr tasksRepo;
    ContextPtr context;
    NotifierPtr notifier;
};

}
