#pragma once

#include <internal/queue.hpp>
#include <internal/notify.hpp>

#include <yplatform/ptree.h>

#include <ymod_taskmaster/service.hpp>
#include <internal/logger.hpp>

namespace ymod_taskmaster {

class ServiceImpl : public Service {
public:
    void init(const ptree& __xml);
    void reload(const ptree& __xml);
    void start();
    void stop();
    void fini();

    Result planTaskIfAsync(TaskPtr task, const size_t midsCount,
                           ContextPtr context, YieldCtx yieldCtx) override;
    Result planTaskIfAsync(TaskPtr task, const Mids& mids,
                           ContextPtr context, YieldCtx yieldCtx) override;
    TaskGroupId planTask(TaskPtr task, const Mids& mids,
                         ContextPtr context, YieldCtx yieldCtx) override;
    TaskStatParams readTask(const UserId& uid, const TaskId& taskId,
                            ContextPtr context, YieldCtx yieldCtx) override;

    bool getChunk(ChunkHandler handler, ContextPtr context,
                  const std::string& launchId, YieldCtx yieldCtx) override;
    UserStat getUserStat(const std::string& uid, ContextPtr context, YieldCtx yieldCtx) override;
    const QueueSettings& getQueueSettings() const override;

private:
    void loadSettings(const ptree& config);
    QueuePtr makeQueue(ContextPtr context);

    Settings settings;
    RepositoryPtr pgRepo;
    http_getter::TypedModulePtr httpGetter;
};

}
