#ifndef TASKS_REPOSITORY_BACKEND_HPP_2014_08_01
#define TASKS_REPOSITORY_BACKEND_HPP_2014_08_01

#include <ymod_taskmaster/types.hpp>
#include <internal/user.hpp>
#include <internal/chunk.hpp>
#include <mail/mops/ymod_taskmaster/ymod_db/include/repository.h>

namespace ymod_taskmaster {

class TasksStoragePg {
public:
    TasksStoragePg(RepositoryPtr pgRequest, ContextPtr context);
    void pushTask(const User& user, const ChunksData& chunksData, const TaskInfo& taskInfo,
                  YieldCtx yieldCtx);
    bool canPushTask(const User& user, size_t tasksLimit, YieldCtx yieldCtx);
    bool hasTasks(const User& user, YieldCtx yieldCtx) const;
    TaskStatParams readTask(const User& user, const TaskId& taskId, YieldCtx yieldCtx);
private:
    RepositoryPtr pgRequest_;
    ContextPtr context_;
};

} // namespace

#endif // TASKS_REPOSITORY_BACKEND_HPP_2014_08_01
