#pragma once

#include <unordered_map>

#include <internal/user.hpp>
#include <internal/users_storage_pg.hpp>
#include <internal/logger.hpp>

namespace ymod_taskmaster {

class UsersRepositoryImpl : public UsersRepository {
public:
    UsersRepositoryImpl(RepositoryPtr pgRequest,
                        std::chrono::microseconds lockTimeout,
                        ContextPtr context)
        : pgRepo(std::move(pgRequest), context),
          lockTimeout(std::move(lockTimeout)),
          logger_(getContextLogger(context)),
          context(std::move(context))
    {}
    virtual ~UsersRepositoryImpl() {}

    virtual Users chooseUsers(size_t limit, YieldCtx yieldCtx);
    UserStat userStat(const UserId& uid, YieldCtx yieldCtx);

private:
    virtual bool tryWorkerLock(const User& user, const std::string& launchId, YieldCtx yieldCtx);
    virtual void unlockWorker(const User& user, const std::string& launchId, YieldCtx yieldCtx);

    UsersStoragePg pgRepo;
    std::chrono::microseconds lockTimeout;
    ContextLogger logger_;
    ContextPtr context;
};

}
