#ifndef USERS_STORAGE_PG_HPP_2014_12_16
#define USERS_STORAGE_PG_HPP_2014_12_16

#include <ymod_taskmaster/context.hpp>
#include <mail/io_result/include/io_result/coro.h>
#include <mail/mops/ymod_taskmaster/ymod_db/include/repository.h>

namespace  ymod_taskmaster {

class UsersStoragePg {
public:
    UsersStoragePg(RepositoryPtr pgRequest, ContextPtr context)
        : pgRequest_(std::move(pgRequest)), context_(std::move(context))
    {}

    Users chooseUsers(size_t limit, YieldCtx yieldCtx) {
        return fromSequence<Users>(
            pgRequest_->chooseUsers(limit, context_, io_result::make_yield_context(yieldCtx))
        );
    }

    UserStat userStat(const User& user, YieldCtx yieldCtx) {
        return UserStat { fromSequence<TasksStatParams>(
            pgRequest_->userStat(user, context_, io_result::make_yield_context(yieldCtx))
        )};
    }

    bool lockUser(const User& user, const std::chrono::microseconds& ttl,
                  const std::string& launchId, YieldCtx yieldCtx) {
        return pgRequest_->acquireLock(user, ttl, launchId, context_, io_result::make_yield_context(yieldCtx));
    }

    bool unlockUser(const User& user, const std::string& launchId, YieldCtx yieldCtx) {
        return pgRequest_->releaseLock(user, launchId, context_, io_result::make_yield_context(yieldCtx));

    }

private:
    RepositoryPtr pgRequest_;
    ContextPtr context_;
};

} // namespace

#endif // USERS_STORAGE_PG_HPP_2014_11_28
