#ifndef MARSHALLING_HPP_
#define MARSHALLING_HPP_

#include <ymod_taskmaster/types.hpp>
#include <ymod_taskmaster/task.hpp>
#include <yamail/data/reflection/reflection.h>
#include <mailbox_oper/reflection.h>

YREFLECTION_ADAPT_ADT(ymod_taskmaster::TaskStatParams,
    YREFLECTION_ROPROPERTY(ymod_taskmaster::TaskId, taskId)
    YREFLECTION_ROPROPERTY(std::string, taskGroupId)
    YREFLECTION_ROPROPERTY(std::string, type)
    YREFLECTION_ROPROPERTY(int, creationTimestamp)
    YREFLECTION_ROPROPERTY(std::size_t, remainedChunksCount)
    YREFLECTION_ROPROPERTY(std::size_t, totalChunksCount)
)

BOOST_FUSION_ADAPT_STRUCT(ymod_taskmaster::UserStat,
    (ymod_taskmaster::TasksStatParams, tasks)
)

YREFLECTION_ADAPT_ADT(ymod_taskmaster::TaskData,
    YREFLECTION_MEMBER(mbox_oper::MailboxOperParams, commonParams)
    YREFLECTION_ENUM_MEMBER(ymod_taskmaster::TaskType, type)
    YREFLECTION_MEMBER(ymod_taskmaster::TaskId, id)
    YREFLECTION_MEMBER(std::string, taskGroupId)
    YREFLECTION_MEMBER(mbox_oper::MidsSourceData, source)
    YREFLECTION_MEMBER(bool, resolveMids)
    YREFLECTION_MEMBER(ymod_taskmaster::TaskId, nestedTaskId)
    YREFLECTION_MEMBER(ymod_taskmaster::OptSpamParams, spamParams)
    YREFLECTION_MEMBER(ymod_taskmaster::OptUnspamParams, unspamParams)
    YREFLECTION_MEMBER(ymod_taskmaster::OptPurgeParams, purgeParams)
    YREFLECTION_MEMBER(ymod_taskmaster::OptTrashParams, trashParams)
    YREFLECTION_MEMBER(ymod_taskmaster::OptMarkParams, markParams)
    YREFLECTION_MEMBER(ymod_taskmaster::OptMoveParams, moveParams)
    YREFLECTION_MEMBER(ymod_taskmaster::OptLabelParams, labelParams)
    YREFLECTION_MEMBER(ymod_taskmaster::OptUnlabelParams, unlabelParams)
    YREFLECTION_MEMBER(ymod_taskmaster::OptDeleteLabelParams, deleteLabelParams)
    YREFLECTION_MEMBER(ymod_taskmaster::OptDeleteFolderParams, deleteFolderParams)
    YREFLECTION_MEMBER(ymod_taskmaster::OptRemoveParams, removeParams)
    YREFLECTION_MEMBER(ymod_taskmaster::OptComplexMoveParams, complexMoveParams)
)

YREFLECTION_ADAPT_ADT(ymod_taskmaster::TaskInfo,
    YREFLECTION_MEMBER(ymod_taskmaster::OptVersion, version)
    YREFLECTION_MEMBER(ymod_taskmaster::TaskData, taskData)
    YREFLECTION_MEMBER(size_t, creationSecs)
    YREFLECTION_MEMBER(size_t, chunksCount)
)

BOOST_FUSION_ADAPT_STRUCT(ymod_taskmaster::ChunkInfo,
    (ymod_taskmaster::ChunkId, id)
    (ymod_taskmaster::Mids, mids)
)

BOOST_FUSION_ADAPT_STRUCT(ymod_taskmaster::ChunkData,
    (ymod_taskmaster::ChunkInfo, chunk)
    (ymod_taskmaster::TaskInfo, task)
)

namespace ymod_taskmaster {

std::string toString(const ChunkData& data);

std::string toString(const TaskInfo& taskInfo);
TaskInfo makeTaskInfo(const std::string& str);

std::string toString(const ChunkInfo& info);
ChunkInfo makeChunkInfo(const std::string& str);

std::string toString(const ChunksInfo& info);
ChunksInfo makeChunksInfo(const std::string& str);

std::string toString(const Mids& mids);

std::string toString(const TaskStatParams& task);
std::string toString(const UserStat& userStat);

std::string toShortString(const Mids& mids);
std::string toShortString(const std::list<std::string>& mids);

}

#endif /* MARSHALLING_HPP_ */
